#!/bin/sh
#
# Soluti Certificação Digital
# 
# Instalador SafeSign Ubuntu
# Utilização: sudo ./install.sh
#                  ou
#             sudo sh install.sh
#

ID=$(id -u)
ARCH=$(arch)
DEBIAN=0
LOG="./install.log"
BIBLIOTECA="/usr/lib/libaetpkss.so.3.0"
PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin

detectaubuntu() {
	if [ "$DEBIAN" -eq 1 ]; then
		return 0
	fi

	if [ -f /etc/lsb-release ]; then
		DISTRO=$(grep -B1 ^DISTRIB_ID= /etc/lsb-release | cut -d= -f2 | tr '[:upper:]' '[:lower:]')
		if [ $DISTRO = "ubuntu" ]; then
			return 0
		else
			return 1
		fi
	else
		return 1
	fi
}

verificasafesign() {
	dpkg -l | grep safesignidentityclient | grep -q ^ii
	return $?
}

safesigninstallx86() {
	echo "\n########## Instalando SafeSign x86\n\n" >> "$LOG"
	dpkg -i ./x86/SafeSignIC3.0.97-i386-ub1204-admin.deb >> "$LOG" 2>&1
	return $?
}

safesigninstallx64() {
	echo "\n########## Instalando SafeSign x64\n\n" >> "$LOG"
	dpkg -i ./x64/SafeSignIC3.0.97-x86_64-ub1204-admin.deb >> "$LOG" 2>&1
	return $?
}

desinstalarsafesign() {
	echo " [+] Desinstalando o Safesign ...\n"

	dpkg -r libwxgtk2.8-0 libtiff4 libwxbase2.8-0 safesignidentityclient > /dev/null 2>&1

	if [ $DEBIAN -eq 1 ]; then
		dpkg -r libjpeg8 > /dev/null 2>&1
	fi
}

biblioteca_firefox() {
	dpkg -l | egrep '(firefox|iceweasel)' | grep -q ^ii
	if [ $? -ne 0 ]; then
		return 1
	fi

	MODUTIL=/usr/bin/modutil
	echo " [+] Configurando biblioteca Safesign no Firefox..."

	dpkg -l | grep libnss3-tools | grep -q ^ii
	if [ $? -ne 0 ]; then
		if [ ! -x $MODUTIL ]; then
			echo "\t+ Instalando pacote \"libnss3-tools\"..."
			apt-get install libnss3-tools --quiet=2 > /dev/null 2>&1
		fi
	fi

	if [ -x $MODUTIL ] ; then
		diretorios_mozilla=$(find /home -maxdepth 2 -type d -name .mozilla 2> /dev/null)
	
		if [ -n "$diretorios_mozilla" ] ; then
			DBDIRS=$(find $diretorios_mozilla -name secmod.db -type f -printf "%h\n")
			for profiledir in $DBDIRS
			do
				if [ -d $profiledir ] ; then
					$MODUTIL -dbdir $profiledir -add "Soluti - Cartao Safesign" -libfile $BIBLIOTECA -mechanisms RSA:DES -force > /dev/null 2>&1
				fi
			done

			if [ $? -eq 0 ]; then
				echo "\t+ Biblioteca configurada!\n"
			else
				echo "\t- Não foi possível configurar biblioteca no Firefox!\n"
			fi

		else
			echo "\t- Não foi possível configurar biblioteca no Firefox!\n"
		fi
	else
		echo "\t- Não foi possível configurar biblioteca no Firefox!\n"
	fi
}

atualizarepositorio() {
		echo "\t+ Atualizando lista de repositórios..."
		echo "\n\n########## Atualizando repositórios\n" >> "$LOG"
		apt-get update >> "$LOG" 2>&1

		echo "\t+ Instalando pacotes requeridos..."
		echo "\n\n########## Instalando pacotes requeridos\n\n" >> "$LOG"
		apt-get -f install -y >> "$LOG" 2>&1

}

banner() {
	echo "\n ###################################"
	echo " # "
	echo " #   Soluti Certificação Digital "
	echo " #   Instalador SafeSign Ubuntu "
	echo " # "
	echo " ###################################\n"
}

suporte() {
	echo "\n [-] Não foi possível instalar o Safesign no seu sistema"
	echo "     Entre em contato pelo número:"
	echo "      * (062) 3999-6000 - Opção 2\n"
}

removelog() {
	if [ -f $LOG ]; then
		rm -f "$LOG"
	fi
}

removelog
banner

echo "\nExecução iniciada dia $(date +"%d-%m-%Y") ás $(date +"%H:%M").\n" >> "$LOG"

if [ "$ID" -ne 0 ]; then
	echo " [-] $0: Favor rodar o script como root!\n"
	exit 1
fi

if [ $# -gt 0 ]; then
	if [ "$1" = "--remover" ]; then
		shift 1
		if [ -n "$1" -a "$1" = "--debian" ]; then
			DEBIAN=1
		fi

		verificasafesign

		if [ $? -eq 1 ]; then
			echo " [-] O Safesign não está instalado!\n"
			exit 0
		fi

		desinstalarsafesign
		exit 0

	elif [ "$1" = "--debian" ]; then
		DEBIAN=1

		shift 1
		if [ -n "$1" -a "$1" = "--remover" ]; then
			verificasafesign

			if [ $? -eq 1 ]; then
				echo " [-] O Safesign não está instalado!\n"
				exit 0
			fi

			desinstalarsafesign
			exit 0
		fi
	fi
fi

detectaubuntu
if [ $? -eq 1 ]; then
		echo " [-] Script deverá ser executado na distribuição Ubuntu\n"
		exit 1
fi

verificasafesign
if [ $? -eq 0 ]; then
	echo " [+] Pacote SafeSign já está instalado\n"
	exit 1
fi

echo " [+] Instalando o Safesign..."
if [ "$ARCH" = "i686" -o "$ARCH" = "i386" ]; then
	safesigninstallx86
	if [ $? -ne 0 ]; then
		atualizarepositorio

		if [ $DEBIAN -eq 1 ]; then
			dpkg -i ./x86/debian/libjpeg8_8d-1+deb7u1_i386.deb >> "$LOG" 2>&1
		fi

		dpkg -i ./x86/libtiff4_3.9.6-11_i386.deb ./x86/libwxgtk2.8-0_2.8.12.1-12_i386.deb ./x86/libwxbase2.8-0_2.8.12.1-12_i386.deb >> "$LOG" 2>&1

		safesigninstallx86
		if [ $? -ne 0 ]; then
			suporte
		else
			echo " [+] SafeSign x86 instalado com êxito!\n"
			biblioteca_firefox
			exit 0
		fi
	else
		echo " [+] SafeSign x86 instalado com êxito!\n"
		biblioteca_firefox
		exit 0
	fi

elif [ "$ARCH" = "x86_64" ]; then
	safesigninstallx64
	if [ $? -ne 0 ]; then
		atualizarepositorio

		if [ $DEBIAN -eq 1 ]; then
			dpkg -i ./x64/debian/libjpeg8_8d-1+deb7u1_amd64.deb >> "$LOG" 2>&1
		fi

		dpkg -i ./x64/libtiff4_3.9.6-11_amd64.deb ./x64/libwxgtk2.8-0_2.8.12.1-12_amd64.deb ./x64/libwxbase2.8-0_2.8.12.1-12_amd64.deb >> "$LOG" 2>&1

		safesigninstallx64
		if [ $? -ne 0 ]; then
			suporte
		else
			echo " [+] SafeSign x64 instalado com êxito!\n"
			biblioteca_firefox
			exit 0
		fi

	else
		echo " [+] SafeSign x64 instalado com êxito!\n"
		biblioteca_firefox
		exit 0
	fi
fi
